/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;

@OnlyIn(value=Dist.CLIENT)
public final class HandsRenderManager {
    private static final List<Builder> REGISTRY = new ArrayList<Builder>();

    public static void register(Predicate<InteractionHand, ItemStack> predicate, HandRenderer renderer) {
        REGISTRY.add(new Builder(predicate, renderer));
    }

    public static void onRenderHand(RenderHandEvent event) {
        boolean applied = false;
        for (Builder builder2 : REGISTRY.stream().filter(builder -> builder.PREDICATE.test(event.getHand(), event.getItemStack())).toList()) {
            if (applied) continue;
            event.setCanceled(true);
            PoseStack pose = event.getPoseStack();
            pose.m_85836_();
            pose.m_85837_(0.0, -0.3, -0.8);
            pose.m_85836_();
            builder2.RENDERER.render(event.getHand(), event.getItemStack(), event.getPoseStack(), event.getMultiBufferSource(), event.getSwingProgress(), event.getEquipProgress(), event.getInterpolatedPitch(), event.getPackedLight(), event.getPartialTick());
            pose.m_85849_();
            pose.m_85849_();
        }
    }

    public static class Builder {
        private final Predicate<InteractionHand, ItemStack> PREDICATE;
        private final HandRenderer RENDERER;

        private Builder(Predicate<InteractionHand, ItemStack> predicate, HandRenderer renderer) {
            this.PREDICATE = predicate;
            this.RENDERER = renderer;
        }
    }

    @FunctionalInterface
    public static interface Predicate<A, B> {
        public boolean test(A var1, B var2);
    }

    @FunctionalInterface
    public static interface HandRenderer {
        public void render(InteractionHand var1, ItemStack var2, PoseStack var3, MultiBufferSource var4, float var5, float var6, float var7, int var8, float var9);
    }
}

